<?php
/**
 * Singleton class for logging errors
 * 
 * @author Ivan Dlugoš
 * @copyright Ivan Dlugoš (c) 2007
 *
 */
class ErrorHandler {
	static private $instance = NULL;
	private $mysqli;
	private $logger;
	private $default_logger = 'file';
	
	/**
	 * Assign MySQL connection or set loging to file
	 */
	private function __construct() {
		switch (DEFAULT_ERROR_LOGGER){
			case 'mysql': $this->logger = ($this->mysqli_connect()) ? 'mysql' : 'file'; break;		
			case 'file': $this->logger = 'file'; break;
		}
	}
	
	private function __clone(){
	}
	
	/**
	 * Function used to get class instance
	 * 
	 * e. g. $error_handler = error_handler::get_instance();
	 */
	static function get_instance(){
		if(self::$instance == NULL){
			self::$instance = new error_handler();
		}
		return self::$instance;
	}
	
	/**
	 * Connect to MySQL server and set class variable
	 * 
	 * @return boolean
	 */
	private function mysqli_connect(){
		$this->mysqli = new mysqli(MYSQLHOST, MYSQLLOGIN, MYSQLPASSWORD, MYSQLDBNAME); 					// assign connection with class variable
	    If (mysqli_connect_errno()) {
	    	return FALSE;
	    } else {
	        return TRUE;
	    }
	}
	
	/**
	 * Function for logging errors
	 * 
	 * @param $errno
	 * @param $text
	 * @param $file
	 * @param $line
	 * 
	 * @return boolean
	 */
	public function log_it($errno, $text, $file, $line, $context){
		switch($this->logger){
			case 'mysql':
				if(!$this->log_mysql($errno, $text, $file, $line, $context)){
					if(!$this->log_file($errno, $text, $file, $line)){
						return FALSE;
					} else {
						return TRUE;
					}
				} else {
					return TRUE;
				}
				break;
			case 'file':
				return $this->log_file($errno, $text, $file, $line);
				break;
		}
	} 
	
	private function log_mysql($errno, $text, $file, $line, $context){
		$context = serialize($context);
		$this->mysqli->query("INSERT INTO `error_log` (`errno`, `errtext`, `file_2`, `line`, `context`, `dt`) VALUES ('$errno', '$text', '$file', '$line', '$context', NOW())");
		if($this->mysqli->errno){
			return FALSE;
		} else {
			return TRUE;
		}
	}
	
	private function log_file($errno, $text, $file, $line){
		$data = date('Y/m/d - H:i:s') . " - Súbor: $file - riadok: $line #$errno: $text\r\n";
		$r = file_append(DIRECTORY_LOGS . '/' . str_replace('{date}', date(LOG_DATE_FORMAT), ERRORS_LOG_FILENAME), $data);
		return ($r === false) ? false : true;
	}
}
?>